<?php

use yii\web\UrlNormalizer;

$params = require __DIR__ . '/params.php';
$db = require __DIR__ . '/db.php';

$config = [
	'language' => 'ru-RU',
	'timeZone' => 'Europe/Moscow',
    'id' => 'basic',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
	'name' => 'Онлайн игра Марс',
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'components' => [
        'request' => [
            // !!! insert a secret key in the following (if it is empty) - this is required by cookie validation
            'cookieValidationKey' => 'Lfzzkkt2FO0pRrkwFcM_RmaNN3YlWhFj',
			'baseUrl' => '',
        ],
		
		 'formatter' => [
        'dateFormat' => 'dd.MM.yyyy',
        'decimalSeparator' => ',',
        'thousandSeparator' => ' ',
        'locale' => 'ru-RU',
		],
		
		  'assetManager' => [
        'bundles' => [
            'yii\bootstrap\BootstrapAsset' => [
                'css' => [],
            ],
            'yii\bootstrap\BootstrapPluginAsset' => [
                'js'=>[]
            ],
        ],
		],
	
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'user' => [
            'identityClass' => 'app\models\User',
            'enableAutoLogin' => true,
            'autoRenewCookie' => false,
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
       'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            'useFileTransport' => false,
            'transport' => [
            'class' => 'Swift_SmtpTransport',
            'host' => 'mail.xoo.su', 
            'username' => 'support@xoo.su', 
            'password' => '',
            'port' => '25',
            'encryption' => '',
            ],
],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'db' => $db,
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
				'start' => 'site/start',
				'start/<ref_id:\d+>' => 'site/start',
				'login' => 'site/login',
				'chat' => 'site/chat',
				'cron' => 'site/cron',
                'battles' => 'site/battles',
                'battle' => 'site/battle',
                'battle/lobby/<id:\d+>' => 'site/battle-lobby',
                'battle/join/<id:\d+>' => 'site/battle-join',
				'forgot' => 'site/forgot',
				'tourney' => 'site/tourney',
				'tourney-corp' => 'site/tourney-corp',
                'premium-shop' => 'site/premium-shop',
                'market/page/<page:\d+>' => 'site/market',
                'market' => 'site/market',
                'user/journal/page/<page:\d+>' => 'user/journal',
				'rating' => 'user/rating',
                'user/<id:\d+>' => 'user/index',
				'user/gift/<user_id:\d+>' => 'user/gift',
				'user/gift-to/<user_id:\d+>/<gift_id:\d+>' => 'user/gift-to',
				'user/gift-list/<user_id:\d+>' => 'user/gift-list',
				'user/mail/view/<id:\d+>' => 'user/mailview',
				'forum/<id:\d+>' => 'forum/index',
				'forum/new/<id:\d+>' => 'forum/new',
				'forum/topic/<id:\d+>' => 'forum/topic',
				'corp/<id:\d+>' => 'corp/index',
            
            ],
        ],
    ],
    'params' => $params,
];

if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];
}

return $config;